--  
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
GameObject = {
    Params = {
        ID="eatmachine";
        image="eatmachine_m4";
        width=1;
        height=1;
        --health=3200;
        timerTask=-1;       -- do not change this parameter ( )
        RandomTasks=0;
        GridData= { 
            1
        };
        select_type = 1;
    };
    ActivePoints = { 
        eating = { 
                   { {}, -1,0,0,  0,  -1,0,0 };
                   }; 
        take   = { 
                   { {"portion"}, 0,-1,0, 0,  0,-1,0 };
                   { {"portion"}, 1,-1,0, 0,  1,-1,0 };
                 }; 
    };
    Objects = { };
    -- list of all tasks for an object
    Tasks = {
        eating = { FuncName="SwitchOnTaskExecute", sleeping={0}, timer=8, time_tick=225, skill_up = 0, restore_health=1000 };
        sleep_end = { FuncName="StopOnEndTaskExecute", hand_add=1 };
    };
    -- list of all triggers for an object
    Triggers = { };
    --tasks to be performed after an object is created
    InitActiveTasks = {};
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {"eating"};
};
function GameObject:Get()
    return self;
end


--        
function OnInit()
    aObj = GameObject:Get();   
    if( not aObj.Params.MaxHealth )then
        aObj.Params.MaxHealth = aObj.Params.health;
    end;
end
    
function CreatePortion()
    aObj = GameObject:Get();
    if (aObj.CountPortion == nil) then
        aObj.CountPortion = 0;
    end
    aObj.CountPortion = aObj.CountPortion + 1;
    --ScriptDump("Portion="..aObj.CountPortion);
end

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

-- perform Task EATING over external object and return true if task is completed
function SwitchOnTaskExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.eating.timer; 
        CPP_PlaySound("feedmachine_m",1);
    end
    tTask = tTask - 1;

    CPP_SetAnimState("time_"..tTask);

    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        CPP_SetAnimState("indicator_off");
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("normal");
        CPP_StopSound("feedmachine_m");
        CPP_PlaySound("feedmachine_m_finish",0);
        aObject.CountFree = aObject.CountPortion;
        CPP_RunStringChild("portion","PortionOn();");
        --portion:PortionOn();
        --CPP_RecursiveRun("portion_on",0);
        return 0;
    end
    return 1;
end

function TakePortion()
    aObject = GameObject:Get();
    aObject.CountFree = aObject.CountFree - 1;
    if (aObject.CountFree <= 0) then
        --  
        aObject.CountFree = 0;
        CPP_PutOnTopExpectedTasks("eating");
    end
    --ScriptDump("TakePortion");
    return 0;
end

function StopOnEndTaskExecute()
    CPP_SetAnimState("indicator_off");
    CPP_SetAnimState("normal");
    CPP_StopSound("feedmachine_m");
    return 0;
end
